#pragma once
//  AppRunSettings Class
//
//  Defines the command line breakout for the Instrumentation Package Analyser application
//
//  Version:  1.0.0
//  Build:    01
//
//   Copyright 2011 Hadleigh Marshall Netherlands b.v.

//  Platform Includes
#include	"../DXCommon/Platform/PlatBase.h"							//  Basic platform includes
#include	"../DXCommon/Platform/NotesBase.h"							//  Notes includes
#include	"../DXCommon/DXGlobals.h"									//  Global definitions

//  Local Definitions
#define		OUTPUT_DUMP			1						//  Dump (timeline)
#define		OUTPUT_STATS		2						//  Statistical Report
#define		OUTPUT_CHART		4						//  Chart statistics
#define		MAX_FILE			256						//  Max size for file name

//  Error Messages
#define		MSG_IPA0001E		"IPA0001E: the <filename> parameter is missing."
#define		MSG_IPA0002E		"IPA0002E: Invalid program switch '%s' has been ignored."

//  Unnumbered Messages
#define		MSG_USAGE1			"Usage:"
#define		MSG_USAGE2			"DXIA <filename> [-D][-S][-C]"
#define		MSG_USAGE3			"  <filename>		- Name of the file to analyse"
#define		MSG_USAGE4			"  -D				- Dump the file contents"
#define		MSG_USAGE5			"  -S				- Analyse and report the file contents"
#define		MSG_USAGE6			"  -C				- Chart an analysis of the file contents"
#define		MSG_USAGE7			"Copyright: Hadleigh Marshall Netherlands 2011."

class AppRunSettings
{
public:
	//  Default Constructor
	AppRunSettings(void);

	//  Normal Constructor, takes the command line arguments
	AppRunSettings(int argc, char * argv[]);

	//  Destructor
	~AppRunSettings(void);

	//  Public Members
	BOOL			IsValid;							//  Validity Indicator
	BOOL			AllowExecution;						//  Permission flag to proceed
	char			szFileName[MAX_FILE + 1];			//  File to be analysed
	int				Outputs;							//  Outputs requested

private:
	//  Private Functions
	BOOL SetDefaults(void);								//  Set the application run defaults
	BOOL ValidateParameters(int argc, char * argv[]);	//  Validate Parameters
	void ShowUsage(void);								//  Show program usage
};

