//  DXIPA.h  --  C++ Header File for the DX Instrumentation Package Analyser application
//
//  Copyright 2011 Hadleigh Marshall Netherlands b.v.

//  Ensure that DXIP is defined
#ifndef DXIP
#define			DXIP			1
#endif

//  Platform Includes
#include	"../DXCommon/Platform/PlatBase.h"							//  Basic platform includes
#include	"../DXCommon/Platform/NotesBase.h"							//  Notes includes
#include	"../DXCommon/DXGlobals.h"									//  Global definitions

//  Additional platform includes
#ifdef UNIX
#include	<fcntl.h>													//  Include POSIX File I/O
#endif
#include	<math.h>

//  Local Definitions

//  Application Includes
#include	"AppRunSettings.h"											//  Application Run Settings
#include	"../DXCommon/Threads/ThreadStructs.h"						//  DXIP Definitions
#include	"../DXCommon/Misc/AutoScaleFrequencyAnalyser.h"				//  Auto Scaling Array

//  Identification Constants
#define		APP_NAME				"DXIPA"
#define		APP_TITLE				"DX Instrumentation Package Analyser"
#define		APP_VERSION				"1.0.1 build: 03"

//  Application Constants
#define		DUMPREC_FORMAT			"+%07i, TID=%i, Evt=%i, Prio=%i, Dwell=%i, Mill=%i."
#define		STATREC_FORMAT			" %.*i - %.*i: %i."
#define		MREC_FORMAT				" Count: %i, Mean: %.4f, Standard Deviation: %.4f, Modal value: %.4f (f=%i), Median: %.4f."
#define		HISTLLINE_FORMAT		"  %.*i -|%s"
#define		HISTNLINE_FORMAT		"  %s  |%s"
#define		HISTXAXIS_FORMAT		"  %s   |%s"

//  Return codes
#define		APPRC_NOERROR			0				//  Everything copacetic
#define		APPRC_WARN				4				//  Execution ok, but warnings issued
#define		APPRC_ERROR				8				//  Execution completed with errors
#define		APPRC_FATAL				16				//  Execution could not be completed

//  Information Messages
#define		MSG_IPA0101I			"IPA0101I: Analysis completed on %i records."
#define		MSG_IPA0102I			"IPA0102I: End of File has been reached while reading the Instrumentation Package Recording file."
#define		MSG_IPA0103I			"IPA0103I: Skipping record %i of type %i and length %i."

//  Warning Messages
#define		MSG_IPA0105W			"IPA0105W: Skipping record %i of type %i and length %i."

//  Error Messages
#define		MSG_IPA0050E			"IPA0050E: Unable to start program execution."
#define		MSG_IPA0100E			"IPA0100E: Unable to open the requested file '%s'."
#define		MSG_IPA0104E			"IPA0104E: Failed to advance the file pointer in the recording file by %i bytes, coherence lost."
#define		MSG_IPA0106E			"IPA0106E: Failed to read the next record in the recording file, coherence lost."

//  Function prototypes/Forward declarations
void AnalyseThisFile(char *szFileName, int iOutputs);
#ifdef WIN32
void GetWINAPIError(DWORD dwWinError, char *szMsg);
void AnalyseTheseRecords(HANDLE hfIPR, int iOutputs);
#endif
#ifdef UNIX
void GetUNIXAPIError(int iError, char *szMsg);	
void AnalyseTheseRecords(int hfIPR, int iOutputs);
#endif
void DumpThisRecord(PCRecRC *pcrRec);
void PrintStatsReport(AutoScaleFrequencyAnalyser *asfaDwell, AutoScaleFrequencyAnalyser *asfaMill);
void PrintCharts(AutoScaleFrequencyAnalyser *asfaDwell, AutoScaleFrequencyAnalyser *asfaMill);
void PrintHistogram(char *szTitle, AutoScaleFrequencyAnalyser *asfaData);

